-- ANMERKUNG: siehe "Y TWawi.Views.Auftrag.sql"

--
CREATE OR REPLACE FUNCTION TSystem.views__Wawi_Lagerzugang__recreate() RETURNS VOID AS $$
  BEGIN
    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS Twawi.lagzu_ext;
        DROP VIEW IF EXISTS TWawi.lagzu;
    --
    
    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    CREATE OR REPLACE VIEW TWawi.lagzu AS
      SELECT
      -- Identifikatoren
        dbrid              AS dbrid                   ,--
        w_wen              AS p_id                    ,-- ID der Pos.
        --                 AS p_dokunr                ,-- Referenz auf das zug. Dokument
        --                 AS p_code                  ,-- Code / Klassifikation / Belegtyp
        --                 AS p_nummer                ,-- Belegnummer
        --                 AS p_pos                   ,-- Positionsnummer
        --                 AS p_parent                ,-- Übergeordnete Position (Strukt. Belege)
        --                 AS p_table                 ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        w_aknr             AS p_aknr                  ,-- Artikelnummer
        --                 AS p_aknr_idx              ,-- Artikelindex
        --                 AS p_akbez                 ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        --                 AS p_aknr_referenz         ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        w_zugang           AS p_menge                 ,-- Menge in Positions-ME
        w_zug_mec          AS p_me                    ,-- artmgc.m_id der Positions-ME
        --                 AS p_los                   ,-- Losgröße für Artikel
        w_zugang_uf1       AS p_menge_gme             ,-- Menge in GME
        --                 AS p_mengeb_gme            ,-- Menge bestellt in GME
        --                 AS p_mengel_gme            ,-- Menge geliefert in GME
        w_stkf             AS p_mengef_gme            ,-- Menge fakturiert in GME
        --                 AS p_mengeo                ,-- Offene Menge
        --                 AS p_mengeo_gme            ,-- Offene Menge in GME
        --                 AS p_norm                  ,-- Artikelnorm
        w_ks               AS p_ks                    ,-- Zugeordnete Kostenstelle
        --                 AS p_gme                   ,-- artmgc.m_id der Grundmengeneinheit
        --                 AS p_mec                   ,-- ME-Code der Positions-ME
        --                 AS p_gmec                  ,-- ME-Code der Grund-ME
        --                 AS p_meuf                  ,-- Umrechnungsfaktor von Pos.ME zu GME
      -- Preisdaten
        --                AS p_preis                 ,-- Preis    
        --                AS p_preiseinheit          ,-- Menge auf die sich p_preis bezieht        
        --                AS p_preis_me              ,-- Preis pro ME             
        --                AS p_preis_gwaer           ,-- Preis pro ME in Grundwährung
        --                AS p_preis_gme             ,-- Preis pro GME
        --                AS p_preis_gme_gwaer       ,-- Preis pro GME in Grundwährung
        --                AS p_waer                  ,-- Pos. Währungseinheit
        --                AS p_kurs                  ,-- Pos. Kurs zur Basiswährung
        --                AS p_scode                 ,-- Steuercode
        --                AS p_sproz                 ,-- Steuerprozentsatz
        --                AS p_rabatt                ,-- Rabattsatz (0...100)
        --                AS p_CanRabatt             ,-- Kennzeichen Rabattfähig
      -- Adressdaten
        w_l_krz            AS p_adkrz                 ,-- Adresskürzel (Kunde o. Lieferant)
        --                 AS p_adkrzl                ,-- Adresskürzel Lieferadresse
        --                 AS p_adkrzf                ,-- Adresskürzel Rechnungsadresse
        --                 AS p_apext                 ,-- Kürzel Ansprechpartner extern
        --                 AS p_apextname             ,-- Voller Name Ansprechpartner extern
        --                 AS p_apint                 ,-- Kürzel Ansprechpartner intern
        --                 AS p_apintname             ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        insert_date        AS p_datum_eingang         ,-- Eingangsdatum
        --                 AS p_datum_erfasst         ,-- Erfassdatum
        --                 AS p_datum_soll            ,-- Wunschdatum
        w_zug_dat          AS p_datum_ist             ,-- Bestätigtes Datum
        --                 AS p_datum_istsoll         ,-- COALESCE(Bestätigtes, Wunschdatum )
        --                 AS p_datum_storniert       ,-- Datum an dem die Pos. Storniert wurde
        --                 AS p_definitiv             ,-- Kennzeichen Pos. Definitiv
        w_rech_eing        AS p_done                  ,-- Kennzeichen Pos. Erledigt
        --                 AS p_storniert             ,-- Kennzeichen Pos. Storniert
        --                 AS p_IsBedarf              ,-- Kennzeichen bedarfswirksam
        --                 AS p_IsFertigung           ,-- Kennzeichen Fertigungsartikel
        --                 AS p_IsUmsatz              ,-- Kennzeichen umsatzwirksame Position
        --                 AS p_status                ,-- Allg. Status1
        --                 AS p_status1               ,-- Allg. Status2
        --                 AS p_status2               ,-- Allg. Status3
      -- Referenzen / Struktur
        --                 AS p_rahmen_id             ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        --                 AS p_vorgaenger_table      ,--
        --                 AS p_vorgaenger_id         ,--
        w_lfsnr            AS p_refnummer             ,-- Referenz auf ext.Nummer (Z.Bsp. Bestell-Nr. Kunde)
        --                 AS p_refpos                ,-- Referenz auf ext.Position (Z.Bsp. Bestellpos. - Kunde)
        --                 AS p_an_nr                 ,-- Projektnummer
        --                 AS p_vtp_id                ,-- ID der zugehörigen Vertragsposition
        --                 AS p_ab_ix                 ,-- Zugehörige ABK
        w_q_nr             AS p_q_nr                  ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        --                 AS p_Konto                 ,--
        --                 AS p_txt_ext               ,--
        --                 AS p_txt_ext_rtf           ,--
        w_lbw              AS p_lb_note,
        w_lbt              AS p_txt_int               ,--
        w_lbt_rtf          AS p_txt_int_rtf            --
      FROM wendat;
    --
    
    -- Erweiterter Anzeige-View => Nur lesbar. Felder aus Basis-View und angejointen Tabellen.
    CREATE OR REPLACE VIEW TWawi.lagzu_ext AS
      SELECT
      -- Identifikatoren
        pos.dbrid          AS dbrid                      ,--
        p_id                                             ,-- ID der Pos.
        p_id::VARCHAR      AS p_dokunr                   ,-- Referenz auf das zug. Dokument
        ld_code            AS p_code                     ,-- Code / Klassifikation / Belegtyp
        ld_auftg           AS p_nummer                   ,-- Belegnummer
        ld_pos             AS p_pos                      ,-- Positionsnummer
        NULL::INTEGER      AS p_parent                   ,-- Übergeordnete Position (Strukt. Belege)
        'wendat'::VARCHAR  AS p_table                    ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        p_aknr                                           ,-- Artikelnummer
        COALESCE(ld_aknr_idx, ak_idx) AS p_aknr_idx      ,-- Artikelindex
        COALESCE(ld_akbz, ak_bez)     AS p_akbez         ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        ld_bem                        AS p_aknr_referenz ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        p_menge                                          ,-- Menge in Positions-ME
        p_me                                             ,-- artmgc.m_id der Positions-ME
        ak_los             AS p_los                      ,-- Losgröße für Artikel
        p_menge_gme                                      ,-- Menge in GME
        NULL::NUMERIC      AS p_mengeb_gme               ,-- Menge bestellt in GME
        NULL::NUMERIC      AS p_mengel_gme               ,-- Menge geliefert in GME
        p_mengef_gme                                     ,-- Menge fakturiert in GME
        tartikel.me__menge_uf1__in__menge(p_me, GREATEST(p_menge_gme-p_mengef_gme, 0)) AS p_mengeo,-- Noch zu bestellende Menge
        GREATEST(p_menge_gme-p_mengef_gme, 0)                     AS p_mengeo_gme,-- Noch zu bestellende Menge in GME
        COALESCE(ld_nident, ak_norm) AS p_norm           ,-- Artikelnorm
        p_ks                                             ,-- Zugeordnete Kostenstelle
      -- Mengeneinheitsdaten
        MEData.p_gme                                     ,-- Artmgc.m_id der Grundmengeneinheit
        MEData.p_mec                                     ,-- ME-Code der Positions-ME
        MEData.p_gmec                                    ,-- ME-Code der Grund-ME
        MEData.p_meuf                                    ,-- Umrechnungsfaktor Positions-ME zu Grund-ME
        MEData.p_meiso                                   ,-- ISO-Code der Positions-ME
        MEData.p_gmeiso                                  ,-- ISO-Code der Grund-ME
      -- Preisdaten
      -- Preisdaten
        ld_preis           AS p_preis                    ,-- Preis    
        ld_preiseinheit    AS p_preiseinheit             ,-- Menge auf die sich p_preis bezieht                      
        ld_ep              AS p_preis_me                 ,-- Preis pro ME
        ld_ep_basis_w      AS p_preis_gwaer              ,-- Preis pro ME in Grundwährung
        ld_ep_uf1          AS p_preis_gme                ,-- Preis pro GME
        ld_ep_uf1_basis_w  AS p_preis_gme_gwaer          ,-- Preis pro GME in Grundwährung
        ld_waer            AS p_waer                     ,-- Pos. Währungseinheit
        ld_kurs            AS p_kurs                     ,-- Pos. Kurs zur Basiswährung
        ld_steucode        AS p_scode                    ,-- Steuercode
        ld_steuproz        AS p_sproz                    ,-- Steuerprozentsatz
        ld_arab            AS p_rabatt                   ,-- Rabattsatz (0...100)
        NULL::BOOLEAN      AS p_canRabatt                ,-- Kennzeichen Rabattfähig
        steu_txt           AS p_sbez                     ,-- Steuerbezeichnung
      -- Positionswerte
        p_menge_gme * ld_ep * (1 - COALESCE(ld_arab, 0) / 100)
                           AS p_wert_netto               ,-- Positionswert, exkl. Steuern, (hier nicht: inkl. AbZuschläge)
        p_menge_gme * ld_ep * (1 - COALESCE(ld_arab, 0) / 100) * (1 + COALESCE(ld_steuproz, 0) / 100)
                           AS p_wert_brutto              ,-- Positionswert, inkl. Steuern, (hier nicht: inkl. AbZuschläge)
        p_menge_gme * ld_ep * (1 - COALESCE(ld_arab, 0) / 100) * COALESCE(ld_kurs, 1)
                           AS p_wert_netto_gwaer         ,-- Positionswert, exkl. Steuern, in Grundwährung, (hier nicht: inkl. AbZuschläge)
        p_menge_gme * ld_ep * (1 - COALESCE(ld_arab, 0) / 100) * (1 + COALESCE(ld_steuproz, 0) / 100) * COALESCE(ld_kurs, 1)
                           AS p_wert_brutto_gwaer        ,-- Positionswert, inkl. Steuern, in Grundwährung, (hier nicht: inkl. AbZuschläge)
      -- Adressdaten
        p_adkrz                                          ,-- Adresskürzel (Kunde o. Lieferant)
        ld_krzl            AS p_adkrzl                   ,-- Adresskürzel Lieferadresse
        ld_krzf            AS p_adkrzf                   ,-- Adresskürzel Rechnungsadresse
        ld_lkontaktkrzl    AS p_apext                    ,-- Kürzel Ansprechpartner extern
        ld_lkontakt        AS p_apExtName                ,-- Voller Name Ansprechpartner extern
        ld_kontakt         AS p_apInt                    ,-- Kürzel Ansprechpartner intern
        nameAufloesen(ld_kontakt) AS p_apintname         ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        p_datum_eingang                                  ,-- Eingangsdatum
        p_datum_eingang    AS p_datum_erfasst            ,-- Erfassdatum
        COALESCE(ld_terml, termweek_to_date(ld_termweekl, true), ld_term, termweek_to_date(ld_termweek, true))
                           AS p_datum_soll               ,-- Wunschdatum
        p_datum_ist::DATE  AS p_datum_ist                ,-- Bestätigtes Datum
        COALESCE(p_datum_ist::DATE, ld_terml, termweek_to_date(ld_termweekl, true), ld_term, termweek_to_date(ld_termweek, true))
                           AS p_datum_istsoll            ,-- Eigentlicher Termin
        NULL::DATE         AS p_datum_storniert          ,-- Datum an dem die Pos. Storniert wurde
        true               AS p_definitiv                ,-- Kennzeichen Pos. Definitiv
        COALESCE(p_mengef_gme >= p_menge_gme, false) AS p_done,-- Kennzeichen Pos. Erledigt
        false              AS p_storniert                ,-- Kennzeichen Pos. Storniert
        NULL::BOOLEAN      AS p_IsBedarf                 ,-- Kennzeichen bedarfswirksame Position
        ak_fertigung       AS p_IsFertigung              ,-- Kennzeichen Fertigungsartikel (oder Fert.Position)
        NULL::BOOLEAN      AS p_IsUmsatz                 ,-- Kennzeichen umsatzwirksame Position
        NULL::VARCHAR      AS p_status                   ,-- Allg. Status1
        NULL::VARCHAR      AS p_status1                  ,-- Allg. Status2
        NULL::VARCHAR      AS p_status2                  ,-- Allg. Status3
      -- Referenzen / Struktur
        (SELECT ld_id FROM ldsdok WHERE (ld_code = 'R' OR ld_pos = 0) AND ld_auftg||'/'||ld_pos = ld_rhl_nr)
                           AS p_rahmen_id                ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        'ldsdok'::VARCHAR  AS p_vorgaenger_table         ,--
        w_lds_id           AS p_vorgaenger_id            ,--
        p_refnummer                                      ,-- Referenz auf ext.Nummer   (Z.Bsp. Bestell-Nr.  Kunde)
        NULL::INTEGER      AS p_refpos                   ,-- Referenz auf ext.Position (Z.Bsp. Bestell-Pos. Kunde)
        ld_an_nr           AS p_an_nr                    ,-- Projektnummer
        ld_vtp_id          AS p_vtp_id                   ,-- ID der zugehörigen Vertragsposition
        ld_abk             AS p_ab_ix                    ,-- Zugehörige ABK
        p_q_nr                                           ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        ld_konto           AS p_konto                    ,-- Kontierung
        ld_txt             AS p_txt_ext                  ,-- Positionstext extern
        ld_txt_rtf         AS p_txt_ext_rtf              ,--
        p_txt_int                                        ,-- Positionstext intern
        p_txt_int_rtf                                     --
      FROM TWawi.lagzu AS pos
        JOIN wendat            ON w_wen   = p_id
        JOIN art               ON ak_nr   = p_aknr
        LEFT JOIN ldsdok       ON ld_id   = w_lds_id
        LEFT JOIN steutxt      ON steu_z  = ld_steucode
        -- Informationen zur Mengenumrechnung mit aufnehmen
        , LATERAL( SELECT m2.m_id     AS p_gme,
                          m1.m_mgcode AS p_mec,
                          m2.m_mgcode AS p_gmec,
                          m1.m_uf     AS p_meuf,
                          lang_artmgc_id_iso(p_me)    AS p_meiso,
                          lang_artmgc_id_iso(m2.m_id) AS p_gmeiso
                   FROM art JOIN artmgc m1  ON (m1.m_ak_nr  = ak_nr) AND (m1.m_id = p_me)
                            JOIN artmgc m2  ON (m2.m_ak_nr  = ak_nr) AND (m2.m_mgcode = ak_standard_mgc)
                   WHERE m1.m_ak_nr = pos.p_aknr ) AS medata
      ;
    --
    
    
    
    
  END $$ LANGUAGE plpgsql;
--

--SELECT TSystem.views__Wawi_Lagerzugang__recreate();
